/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.TileEntityBaseScreen;
import com.supermartijn642.core.gui.widget.TextFieldWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TesseractTile;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import com.supermartijn642.tesseract.packets.PacketScreenAddChannel;
import com.supermartijn642.tesseract.screen.LockButton;
import com.supermartijn642.tesseract.screen.TesseractButton;
import com.supermartijn642.tesseract.screen.TesseractScreen;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class TesseractAddChannelScreen
extends TileEntityBaseScreen<TesseractTile> {
    private static final int CHANNEL_MIN_CHARACTERS = 3;
    private static final int CHANNEL_MAX_CHARACTERS = 19;
    private static final ResourceLocation BACKGROUND = new ResourceLocation("tesseract", "textures/gui/add_screen_background.png");
    private final EnumChannelType type;
    private TextFieldWidget nameField;
    private TesseractButton addButton;
    private LockButton lockButton;

    protected TesseractAddChannelScreen(BlockPos pos, EnumChannelType type) {
        super((Component)new TranslatableComponent("gui.tesseract.add.title." + type.name().toLowerCase(Locale.ROOT)), pos);
        this.type = type;
    }

    protected float sizeX(TesseractTile tile) {
        return 144.0f;
    }

    protected float sizeY(TesseractTile tile) {
        return 65.0f;
    }

    protected void addWidgets(TesseractTile tile) {
        this.nameField = (TextFieldWidget)this.addWidget((Widget)new TextFieldWidget(7, 21, 107, 18, "", 19, this::checkChannelName));
        this.nameField.setSuggestion(ClientUtils.translate((String)"gui.tesseract.add.suggestion", (Object[])new Object[0]));
        this.addButton = (TesseractButton)this.addWidget((Widget)new TesseractButton(8, 43, 61, 14, (Component)new TranslatableComponent("gui.tesseract.add.add"), this::addChannel));
        this.addButton.active = false;
        TesseractButton cancelButton = (TesseractButton)this.addWidget((Widget)new TesseractButton(75, 43, 61, 14, (Component)new TranslatableComponent("gui.tesseract.add.cancel"), () -> ClientUtils.displayScreen((Screen)new TesseractScreen(this.tilePos))));
        cancelButton.setRedBackground();
        this.lockButton = (LockButton)this.addWidget((Widget)new LockButton(117, 20));
        this.lockButton.setLocked(true);
    }

    protected void render(PoseStack matrixStack, int mouseX, int mouseY, TesseractTile tile) {
        ScreenUtils.bindTexture((ResourceLocation)BACKGROUND);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)this.sizeX(), (float)this.sizeY());
        ScreenUtils.drawCenteredString((PoseStack)matrixStack, (Component)this.f_96539_, (float)72.0f, (float)6.0f, (int)-1);
    }

    protected void renderTooltips(PoseStack matrixStack, int mouseX, int mouseY, TesseractTile tile) {
    }

    private boolean checkChannelName(String name) {
        if ((name = name.trim()).isEmpty() || name.length() < 3 || name.length() > 20) {
            this.addButton.active = false;
            return false;
        }
        List<Channel> channels = TesseractChannelManager.CLIENT.getChannelsCreatedBy(this.type, ClientUtils.getPlayer().m_142081_());
        boolean isUnique = true;
        for (Channel channel : channels) {
            if (!channel.name.equals(name)) continue;
            isUnique = false;
            break;
        }
        this.addButton.active = isUnique;
        return isUnique;
    }

    private void addChannel() {
        String name = this.nameField.getText().trim();
        if (!this.checkChannelName(name)) {
            return;
        }
        Tesseract.CHANNEL.sendToServer((BasePacket)new PacketScreenAddChannel(this.type, name, this.lockButton.isLocked()));
        ClientUtils.displayScreen((Screen)new TesseractScreen(this.tilePos));
    }
}

